import pandas as pd   
import pickle

# Read the fastfood data
fastfood = pd.read_csv("fastfood.csv")
  
def calculate_daily_calorie_goal(bmr, activity_level):
    activity_multipliers = {
        'sedentary': 1.2,
        'lightly_active': 1.375,
        'moderately_active': 1.55,
        'very_active': 1.725,
        'extra_active': 1.9}
    daily_calorie_goal = bmr * activity_multipliers[activity_level]
    return daily_calorie_goal 

